import pandas as pd
import requests
import json
import gzip
from main import df
import openpyxl


kairosdb_server = "http://192.168.0.220:8080"
url='http://192.168.0.220:8080/api/v1/datapoints/query'
# Simple test [without compression]
data = [
    {
        "name": "Madhu",
        "datapoints": df[['Datetime', 'RH']].values.tolist(),
        "tags": {"project": "table"}
    }
]

response = requests.post(kairosdb_server + "/api/v1/datapoints", json.dumps(data))
print("Simple test [without compression]: \t %d (status code)" % response.status_code)

def minm(query):

    if query=="months":
        payload = json.dumps({

            "metrics": [
                {
                    "tags": {},
                    "name": "Madhu",
                    "aggregators": [
                        {
                            "name": "min",
                            "sampling": {
                                "value": "1",
                                "unit": "months"
                            }
                        }
                    ]
                }
            ],
            "plugins": [],
            "cache_time": 0,
            "start_absolute":1094668200000,
            "end_absolute":1126204200000
        })
        headers = {
            'Content-Type': 'application/json'
        }

        response = requests.request("POST", url, headers=headers, data=payload)

        return response.json()
def maxm(query):

    if query=="months":
        payload = json.dumps({

            "metrics": [
                {
                    "tags": {},
                    "name": "Madhu",
                    "aggregators": [
                        {
                            "name": "max",
                            "sampling": {
                                "value": "1",
                                "unit": "months"
                            }
                        }
                    ]
                }
            ],
            "plugins": [],
            "cache_time": 0,
            "start_absolute":1094668200000,
            "end_absolute":1126204200000
        })
        headers = {
            'Content-Type': 'application/json'
        }

        response = requests.request("POST", url, headers=headers, data=payload)

        return response.json()

def avgm(query):

    if query=="months":
        payload = json.dumps({

            "metrics": [
                {
                    "tags": {},
                    "name": "Madhu",
                    "aggregators": [
                        {
                            "name": "avg",
                            "sampling": {
                                "value": "1",
                                "unit": "months"
                            }
                        }
                    ]
                }
            ],
            "plugins": [],
            "cache_time": 0,
            "start_absolute":1094668200000,
            "end_absolute":1126204200000
        })
        headers = {
            'Content-Type': 'application/json'
        }

        response = requests.request("POST", url, headers=headers, data=payload)

        return response.json()
def monthlyhumiditydata():

    hum2= maxm("months")['queries'][0]['results'][0]['values']
    hum1= minm("months")['queries'][0]['results'][0]['values']
    hum=avgm("months")['queries'][0]['results'][0]['values']
    df1=pd.DataFrame(hum2,columns=["Updated_Date","maxm"])
    df2=pd.DataFrame(hum1, columns=["Updated_Date", "minm"])
    df3=pd.DataFrame(hum, columns=["Updated_Date", "avgm"])

    a=pd.merge(df1,df2,on="Updated_Date")
    b=pd.merge(a,df3,on="Updated_Date")

    b.to_excel("scripts/Data/monthreport.xlsx")
    fpath = 'scripts/Data/'
    fname = 'monthreport.xlsx'
    filepath = fpath + fname
    return filepath, fname